//*********************************************************************
// [COMIDAS sample program by COMIZOA Inc., Ltd]
//
// Subject : 
//   Motion Control, List Motion
// Contents: 
//   -.   ͷƮ ̺Ʈ óϴ α׷ Դϴ. 
//	 -. ͷƮ ̺Ʈó Ͽ Applicationʿ ؾϴ ۾ 
//		 ϴ.
//		1) COMILX_MC_MaskInterrupt()Լ ̿Ͽ ̺Ʈ ũϿ 
//		   ó ͷƮ ̺Ʈ Ѵ.
//		2) CreateEvent() APIԼ ̿Ͽ Event ڵ Ѵ.
//		3) COMILX_MC_EnableInterrupt()Լ ̿Ͽ ͷƮ EnableŰ, 
//         ̺Ʈڵ COMI-LX501 ̹ Ѵ. 
//	    4) WaitForSingleObject() API Լ ̿Ͽ ̺Ʈ ٸ.
//		5) WaitForSingleObject()Լ ReturnǸ ̺Ʈ ߻ ̹Ƿ 
//			COMILX_MC_GetAxisIntState() Լ COMILX_MC_GetIntStatus() Լ
//			̿Ͽ ͷƮ ¸ üũϰ ¿   ġ Ѵ.
// Remarks:
//   -.  α׷ COMI-LX501  Դϴ. 
//*********************************************************************

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "comidaslx.h"

// (ä) ȣ //
#define X_AXIS	0

HANDLE hIntEvent;
BOOL bAbortThread;

void DisplayInterrupt(long dwErrState, long dwEvtState)
{
	char *szErrState[] = {
		"Stop by +SL(Software limit) stop motion", 
		"Stop by -SL(Software limit) stop motion",
		"",
		"Stop by General Comparator stop motion",
		"",
		"+EL signal is turning ON stop motion",
		"-EL signal is turning ON stop motion",
		"ALM signal is turning ON stop motion",
		"",
		"",
		"SD signal turning ON after deceleration",
		"Abnormal operation data stop motion",
		"",
		"",
		"PA/PB input buffer counter overflows",
		"In-position counter counts beyond the range at the time of interpolation",
	};
	char *szEvtState[] = {
		"Normal Stop",
		"Succesive start of the next operation",
		"",
		"",
		"Start of acceleration",
		"End of acceleration",
		"Start of deceleration",
		"End of deceleration",
		"",
		"",
		"Position error tolerance exceed",
		"General Comparator",
		"Compared triggered for axis 0, 1",
		"",
		"Latched for axis2,3",
		"ORG input signal ON",
		"SD input signal ON"
	};

	for(int i=0; i<16; i++){
		if(dwErrState & (1<<i))
			printf("Error Interrupt : %s\n", szErrState[i]);
	}

	for(i=0; i<16; i++){
		if(dwEvtState & (1<<i))
			printf("Event Interrupt : %s\n", szEvtState[i]);
	}
}


//*********************************************************************
// InterruptEventThread() : Interrupt Event ޱ   
// 
//*********************************************************************
DWORD WINAPI InterruptEventThread( LPVOID pParam )
{
	HANDLE hDevice = (HANDLE)pParam;
	long nErrState, nEvtState;
	char szMessage[300];
	int i;
	bAbortThread = FALSE;
	while(!bAbortThread){
		// Waiting for interrupt event //
		WaitForSingleObject(hIntEvent, INFINITE);
		// ̺Ʈ ߻ϸ X࿡ ͷƮ ߻  üũϰ      //
		// X࿡ ߻ ̸ ͷƮ ߻  ȭ鿡 ǥѴ.    //
		// , α׷   ̺Ʈ  ߻ŰǷ             // 
		// bAbortThread TRUE̸  ߻ ̺Ʈ̹Ƿ ó ʴ´.// 
		if(!bAbortThread && COMILX_MC_GetAxisIntState(hDevice, X_AXIS)){
			COMILX_MC_GetIntStatus(hDevice, 0, &nErrState, &nEvtState);
			DisplayInterrupt(nErrState, nEvtState);
		}
	}
	bAbortThread=FALSE;
	return TRUE;
}

void main()
{
	double fDistList[2];

	if(!COMILX_LoadDll())
		exit(-1); // Load Dll Failure
	
	HANDLE hDevice = COMILX_LoadDevice(COMI_LX501, 0);
	if(hDevice == INVALID_HANDLE_VALUE)
		exit(-1); // Load Device Failure
	
	COMILX_MC_Reset(hDevice);

	hIntEvent = CreateEvent(NULL, 0, 0, "");
	COMILX_MC_MaskInterrupt(hDevice, 0, 0xfff);
	COMILX_MC_EnableInterrupt(hDevice, hIntEvent);
	CreateThread(0, 0, InterruptEventThread, hDevice, 0, NULL);
	
	COMILX_MC_SetSpeedMode(hDevice, X_AXIS, 1); 
	COMILX_MC_SetSpeed(hDevice, X_AXIS, 0, 10000); 
	COMILX_MC_SetAccel(hDevice, X_AXIS, 20000, 20000);
	// (+) Velocity Move  //
	COMILX_MC_StartVMove(hDevice, X_AXIS, 1);
	// Stop (Ű)    Velocity Move  //
	while(!kbhit())
		;
	//    //
	COMILX_MC_Stop(hDevice, X_AXIS);
	
	bAbortThread=TRUE; // Monitor_Log_Thread  Ų.
	// Monitor_Log_Thread 尡 Event Waitingϰ ִ ̸ //
	// Wait¿    ̺Ʈ ߻Ų.         //
	SetEvent(hIntEvent); 
	while(bAbortThread) // Monitor_Log_Thread 尡   ٸ.
		;
	CloseHandle(hIntEvent);
	COMILX_UnloadDevice(hDevice);
	COMILX_UnloadDll();
}


